#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <vlib.h>


void main(ULONG argc, UBYTE *argv[])
{
ULONG numframes, offset = 0, smallest = 0, largest = 0;
Sound *soundtrack;

    // Print banner
    printf("PlayFLC using the VLib game SDK\n\n");

    if(argc == 1) {
        printf("Usage: playflc [animname]\n");
        return;
    }

    if(IsFlic(argv[1]) == FALSE) {
        printf("That file is not an FLC or an FLI animation.\n");
        return;
    }

    if((fli_header.width > 1024) | (fli_header.height > 768)) {
        printf("That animation's frames are too large.\n");
        return;
    }

    if(AllocDoubleBuffer(1024 * 768) == FALSE) {
        printf("Not enought memory for double buffer.\n");
        return;
    }

    // Set the most appropriate video mode for the animation
    if((fli_header.width <= 320) & (fli_header.height <= 200))
        SetVideoMode(VGA256);
    else {
        if(FindBestVesaMode(fli_header.width, fli_header.height, 8, TRUE) ==
           FALSE) {
            printf("Could not initialize VESA mode.\n");
            return;
        }
    }

    // Clear the screen
    ScreenFill(0);

    if(argc == 3) {
        if(IsWAV(argv[2]) == TRUE) {
            soundtrack = LoadSound(argv[2]);
            if(soundtrack)
                InitSoundSystem(wav_header.nSamplesPerSec);
        }
    }

    // Set up the timer so that we can playback at a consistant speed
    GameTimer();
    ChangeTimer(TIMER60HZ);

    // Open the animation and determine number of frames
    numframes = OpenFLI(argv[1]);

    // This will center the animation on the screen
    offset = ((screen_height - fli_header.height) / 2) * screen_width;
    offset += (screen_width - fli_header.width) / 2;


    InitFPS();
    while(numframes) {

        // Load the (first) next frame of the animation
        LoadFLIFrame(double_buffer + offset, colormap);

        // If the palette was changed, set the new palette
        if(fli_palette_changed == TRUE)
            SetPalette(colormap);

        // Pause the appropriate amount of time before displaying
        PaceFLI();
        DoubleBuffer();

        // Start sound if present
        if((soundtrack->data != 0) & (voicecount == 0))
            PlaySound(soundtrack, 255);

        numframes--;
        if(smallest == 0)
            smallest = fli_frame.size;
        else
            smallest = min(fli_frame.size, smallest);
        largest = max(fli_frame.size, largest);

        if(GetKey())
            numframes = 0;
    }

    CloseFLI();
    SetVideoMode(TEXT80);

    ReportFPS();
    printf("\n       File size: %d\n", fli_header.size);
    printf("Frame dimensions: %d x %d\n", fli_header.width, fli_header.height);
    printf("      Frame size: %d\n", fli_header.width * fli_header.height);
    printf("Number of frames: %d\n", fli_header.frames);
    printf("   Desired speed: %d fps\n", (ULONG)1000 / fli_header.speed);
    printf("\nSmallest delta size: %d\n", smallest);
    printf("Largest delta size:  %d\n", largest);

    if(soundtrack->data != 0)
        FreeSoundSystem();
    ChangeTimer(TIMER18HZ);
    OldTimer();
    FreeDoubleBuffer();
}